import type { Builder, ConfigFunction, Index } from 'lunr';
import lunr from 'lunr';
import type { Doc } from '../documentation-resolver';
import { getDocuments, requireDocument } from '../documentation-resolver';

// istanbul ignore next: non-production
const lunrConfig: ConfigFunction = (ctx: Builder) => {
  ctx.ref('urlPath');
  ctx.field('content');
  ctx.field('title', { boost: 10 });

  Object.values(getDocuments()).forEach((d) => {
    ctx.add({
      content: requireDocument(d.filePath),
      title: d.title,
      urlPath: d.urlPath,
    });
  });
};

let searchIndex: Index | null = null;

interface SearchResult extends Doc {
  title: string;
}

// istanbul ignore next: non-production
export function search(term: string): SearchResult[] {
  if (!searchIndex) {
    // TODO: Index during build process rather than JIT
    // https://jira.twitch.com/browse/EMP-2945
    searchIndex = lunr(lunrConfig);
  }

  if (!term) {
    return [];
  }

  const docs = getDocuments();

  return searchIndex
    .search(term)
    .slice(0, 5)
    .map((r) => {
      const doc = docs.find((d) => d.urlPath === r.ref);
      if (!doc) {
        throw new Error(`No doc found for result: ${r.ref}`);
      }

      return {
        filePath: doc.filePath,
        title: doc.title,
        urlPath: doc.urlPath,
      };
    });
}
