# Tachyon Starshot

Twitch's web-based TV client.

## Getting Started

1. [Setup your Dev Environment](#setting-up-your-dev-environment).
1. [Setup your devices for local testing](./processes/device-testing.md).
1. [Review the documentation on local development](./processes/local-development.md).
1. [Review examples of best practices and common patterns](../../patterns/README.md).

## Setting Up Your Dev Environment

1. Ensure that you have run through the
   [First Time Setup](https://git.xarth.tv/pages/emerging-platforms/tachyon) for
   Tachyon
1. Integrate ESLint into your IDE.
1. Setup Prettier to
   [automatically run on save](https://prettier.io/docs/en/editors.html) in your
   IDE.
1. Run `yarn run:sst` from the root of the repo and visit the app in the browser
   at: https://localhost.tv.twitch.tv.

After you've gotten everything running, you'll eventually need to setup Chromium
38 and 53 per the instructions below. Don't do this before you've gotten
everything else working and are comfortable in the project, as it can be pretty
derailing. However, these are required before doing any big feature work to
ensure you don't build anything that won't work on our older targets.

### Setting up Chromium 38 and 53

1. Install
   [Parallels Desktop for Mac](https://www.parallels.com/welcome-trial/). This
   will get you the trial to get started. Once downloaded, use your company
   Google account to login.
2. Follow the
   [support article on installing macOS Mojave](https://kb.parallels.com/124786).
   You can skip the part where it talks about disconnecting your network and
   changing the date; as long as Mojave installer is in your Applications
   directory Parallels will auto-discover it. Ensure that you configure the
   image with enough system resources to effectively run Chromium. The
   installation will first install a recovery partition inside the VM and boot
   that. From there, you'll need to select "Reinstall macOS" and then select
   "Macintosh HD" (which is the VM one, not your host). As an alternative to
   downloading Mojave from Apple, you can also use this
   [Mojave Installer ISO](https://www.dropbox.com/s/xw2waliz8j5bad9/Mojave.iso?dl=0).
   If you intend on using the ISO file for a virtual machine, you simply need to
   select the `Mojave.iso` disk image in the virtual machine app as a boot disk,
   or mount it within the VM as any other disk image would be.
3. [Download prebuilt Chromium 38 and 53](https://drive.google.com/drive/folders/1wT07VF1pASeKdMPpkMejCEgZPW9UfZn6)
   and put them in your Applications directory. 53 is 64-bit and can run
   natively, so it can go directly into your host Applications directory.
   Drag-and-drop 38 into your VM's Applications directory.
4. On your Mac host, edit the file
   `/usr/local/amazon/var/quarantine/template-com.amazon.custom` (do this with
   sudo, and create the file if it doesn’t exist already). In the `## FILTER`
   section, add a line that looks like this:

```
## FILTER
pass in inet proto {tcp} from any to any port 19000 keep state
```

5. Save this file, and disconnect/reconnect to wifi to bounce your network
   adapter and reload with this new setting. Open Chromium 38 in the VM and go
   to `https://10.211.55.2:19000/` (accepting cert warnings) and you should see
   Starshot running. If you don't see starshot running, verify that you are not
   connected to the Amazon VPN as it can cause issues with the network sharing
   between the VM and host.
6. Once everything works, place an order for
   [Parallels at IT Marketplace](https://itmarketplace.corp.amazon.com/detail_pages/846)
   to get a proper license. This will trigger a request for approval from your
   manager, so make sure to let them know to expect it.
7. For a more pleasant debugging experience,
   [Install Parallels Tools](https://kb.parallels.com/115835) to your VM image.
   This will let you resize the display and not force you to debug in 1024x768.

## App Technologies

Major Technology choices:

- Framework, Build Process, and Server-Side Rendering:
  [Next.js](https://nextjs.org/docs/#setup).
- View Layer: [React](https://reactjs.org/docs/getting-started.html).
- [Core-UI](https://design.xarth.tv/user-interface/getting-started) for
  presentational components
- Well-scoped CSS in component files:
  [Styled Components](https://www.styled-components.com).
- Twitch GQL Access through
  [Relay Modern](https://facebook.github.io/relay/docs/en/introduction-to-relay.html).
- Navigation management via
  [tachyon-tv-nav](../../packages/living-room/tv-nav/README.md).

## Browser Feature Constraints

We currently [support](../../native-apps/webos/README.md#support-matrix) back to
webOS 3.5 (LG 2017) which uses Chromium 38 as it's web engine. Here's a useful
comparison of
[features](https://caniuse.com/#compare=chrome+38,chrome+53,chrome+80) for
Chromium 38 vs Chrome 80.

Known Trouble Areas in Starshot for Chrome 38:

- [CSS Variables](https://caniuse.com/#search=CSS%20Variables)
- [WASM](https://caniuse.com/#feat=wasm): Forces us to use Player-Core's
  [ASM](https://caniuse.com/#feat=asmjs) worker.
- [focus-within](https://caniuse.com/#search=focus-within): Affects Core-UI
  MediaCardImage focus behavior.
- Missing 'key' on KeyEvent. (Not a problem in Chromium 53)
- [scroll-snap](https://caniuse.com/#search=scroll-snap) would let us vastly
  simplify our shelf scrolling system
- [Focus preventScroll](https://caniuse.com/#search=preventScroll) would allow
  us to vastly simplify our current layout system which relies on setting focus
  on HTML elements so that key presses work.

Known Trouble Areas in Starshot for Chrome 53:

- [SameSite Cookies](https://caniuse.com/#feat=same-site-cookie-attribute). See
  [cookies](../../internal-docs/cookies.md) for more information.

## Local Development

Known Chrome 38 Local Dev Issues:

- Chrome 38 can only be run locally via prodlike. See
  [Simulating A Production Build Locally](#simulating-a-production-build-locally).
- Chrome 38 can't play video -- it doesn't have the required codecs. This must
  be tested on a TV directly.

### Running Locally

```sh
$ yarn start
```

Note for Firefox users: In order to support HTTPS in local development, we use a
self-signed certificate that is added to your system keychain. Because Firefox
maintains its own keychain, when your browser first attempts to load the app it
will attempt to prevent you from visiting the site. You will need to override
its warning by clicking the "Advanced" button on this error page:

![Firefox Untrusted Page](../../apps/sky-map/public/static/tomorrow/processes/local-development/ff-untrusted-https-page.png)

#### Simulating A Production Build Locally

If you need to run Starshot locally as a fully optimized production build:

```sh
$ yarn prodlike
```

NOTE: This is the only way to test Chrome 38 Locally.

#### Running With A Specific Platform

Both `yarn start` and `yarn prodlike` allow you to launch Starshot with a
specific
["platform" value](../../packages/tachyon-core/environment/src/Platform/index.ts):

```sh
$ TACHYON_PLATFORM=<value>_web_tv yarn start
```

#### Profiling A Production Build With [React Profiler](https://reactjs.org/blog/2018/09/10/introducing-the-react-profiler.html)

Runs `prodlike` with a slightly
[altered build](https://gist.github.com/bvaughn/25e6233aeb1b4f0cdb8d8366e54a3977)
of React:

```sh
$ yarn profile
```

#### Running A Production Environment Locally

If you need to run a full Docker Starshot environment locally, from the root of
Tachyon:

```sh
$ yarn docker:sst
```

Then visit `localhost:3003`.

### Running Unit Tests

Tachyon uses [Jest](https://jestjs.io/docs/en/cli) to run unit tests:

```sh
$ yarn test [TestPathPattern]
```

Or for watch mode:

```sh
$ yarn test:watch [TestPathPattern]
```

### Code Formatting

#### Linting via [ESLint](https://eslint.org/)

```sh
$ yarn lint:fix
```

_Note: Integrate ESLint into your IDE for the best experience._

## Architecture

### No Caching Of SSR'd Pages

Starshot does not currently cache any of its Server Side Rendered pages due to
the fact that they will be rendering for logged-in users.

### Error Handling / 5XX Pages

In the event of an unhandled error, Next will catch it and render our Error page
with a reload button. This will do a full page reload causing a SSR page
request. This allows us to cache-bust within the Starshot webview in the event
that we've deployed a minor hot-fix or bug patch.

## Misc Information

### Styling

Express style sizing as `rems` or `vw`. Do not use `vh`, `px` or other sizing.
This constraint enables us to scale the intended visual design across various
device sizes.

720x1280 and 1080x1920 are first class dimensions, and all other dimensions are
supported best-effort.
