import { beforeEach, cy, describe, it } from 'local-cypress';

describe('GamesDirectory', () => {
  beforeEach(() => {
    // always start on directory page
    cy.visit('/directory');
  });

  it('asserts scroll works on directory page', () => {
    // On initial rendering we should have only 24 elements
    // 3 rows of cards
    cy.get('main')
      .findSc('ScScrollContainer')
      .as('GamesTower')
      .children()
      .should('have.length', 24);
    // Scroll down once
    cy.tvScroll('down');
    // Scroll down once again
    cy.tvScroll('down');
    // Assert we now have 32 elements
    // 4 rows of cards
    cy.get('@GamesTower').children().should('have.length', 32);
    // Scroll up once
    cy.tvScroll('up');
    // Scroll up once again
    cy.tvScroll('up');
    // Assert length has gone back to 24 elements
    // 3 rows of cards
    cy.get('@GamesTower').children().should('have.length', 24);
    // Assert first card in first row is highlighted element
    cy.get('@GamesTower')
      .children()
      .first()
      .findSc('ScCoreLink')
      .should('have.focus');
  });
});
