import { cy, it } from 'local-cypress';

describe('Homepage', () => {
  beforeEach(() => {
    // always start on home page
    cy.visit('/');
  });

  it('can navigate to directory page via button inputs', () => {
    // navigate to browse
    // focus starts on first card of first row
    cy.tvNav('up');
    cy.tvNav('right');
    cy.tvNav('right');
    // Submit enter on browse button to enter directory url
    cy.tvEnter();
    // Assert we are on games directory now
    cy.location('pathname').should('eq', '/directory');
  });

  it('shows page buttons when mouse moves and they trigger row movement', () => {
    // Asserts first row of cards is initially of length 5
    cy.get('section')
      .first()
      .findSc('ScScrollContainer')
      .as('firstRecsRow')
      .children()
      .should('have.length', 5);
    // Hovers around page to display right arrow button
    cy.get('body').trigger('mousemove');
    // Asserts right arrow button is present and clicks on it
    cy.getSc('ScPageButton').last().click();
    // Asserts first row of cards now has length 6
    cy.get('@firstRecsRow').children().should('have.length', 6);
  });
});
