import { cy, it } from 'local-cypress';

describe('Search', () => {
  it('tests search bar functionality', () => {
    const typedText = 'counter';
    // Load search page
    cy.visit('/search');
    // Check we are on search page now
    cy.get('section').should('not.exist');
    // Confirm search bar is focused element and hit enter to start typing
    cy.getSc('ScTextInputWrapper').should('have.focus').tvEnter();
    // // Enter search term, type value, and assert value typed is the same as value shown in search bar
    cy.get('input[type=search]')
      .should('have.focus')
      .type(typedText)
      .should('have.value', typedText)
      .tvEnter();
    // Ensure we are on results page now
    cy.get('section').should('have.length.gte', 2);
  });
});
