# Installing the Vewd Emulator

Vewd is a company that provides several different products related to smart TVs,
including a TV browser platform as well as a testing/certification service for
smart TV apps.

Although we use our own QA, BD occasionally uses Vewd as a way to test against
TV platforms that we don't yet support to get a sense of how well our app
performs so we can guage the level of effort to move to those platforms in the
future.

One extremely useful thing Vewd provides is emulators that run in
[VirtualBox](https://www.virtualbox.org/wiki/Downloads) which can be used to
roughly reproduce the experience of running on a low end TV with an older
browser version.

## Installation Steps

These steps are the high level steps you'll need to take to get the Vewd and
Opera TV platform emulators installed. For more context, please see the
[Vewd Emulator Docs](https://developer.vewd.com/display/OTV/Vewd+TV+Emulator+4.x)
and the
[VirtualBox Docs](https://download.virtualbox.org/virtualbox/6.1.22/UserManual.pdf)

1. Download the emulator VM images for
   [Vewd TV](https://s3-eu-west-1.amazonaws.com/acp.otvs.tv/emulator/Vewd_TV_Emulator_4.11.zip)
   and
   [Opera TV](https://s3-eu-west-1.amazonaws.com/acp.otvs.tv/emulator/Opera_TV_Emulator_4.9_v3.0.12.TTS.zip)

1. Download the
   [VirtualBox OSX Host](https://download.virtualbox.org/virtualbox/6.1.22/VirtualBox-6.1.22-144080-OSX.dmg)
   as well as the
   [VirtualBox Oracle VM Extension](https://download.virtualbox.org/virtualbox/6.1.22/Oracle_VM_VirtualBox_Extension_Pack-6.1.22.vbox-extpack)

1. Install VirtualBox OSX Host, following all onscreen prompts from the
   installer.

1. Double click the Oracle VM extension once VirtualBox is installed, and this
   should open a prompt to install this extension into VirtualBox.

1. Launch VirtualBox and go to `File > Import Appliance` then navigate to the
   Vewd TV image that you downloaded. This will open a series of dialogs to
   confirm some specific VM settings. You should just be able to use the
   defaults for all of this. Then perform the same steps for the Opera TV image.

1. At this point you should see the Vewd and Opera emulators on the left hand
   side of the VirtualBox window, at which point you can double click either VM
   to launch them.

1. When launching one of the VMs, you will probably be prompted to enable a
   bunch of OSX permissions (keyboard, etc) so make sure to enable these and
   then possibly restart the app.

1. Once the emulator VM has launched, you'll be prompted to install some
   extensions to support multimedia playback and support different screen sizes.
   Click `Install` on all of these extensions, and then wait a few minutes for
   them to build and install.

1. Once all these steps have finished, your emulator should be up and running.

## Useful Tips

1. You can pull up a debug window with console logs and a convenient UI to
   specify the app URL by going to `http://localhost:5555/`

1. You can use the debug UI to set your native resolution to either 720p or
   1080p. I've noticed that this doesn't scale up with retina, so 720p can look
   a bit small, and VirtualBox window scaling seems to be quite slow, so using
   1080p might be desirable.
