# Testing Player Core on Starshot

Whenever we need to verify a new version of player core, we should run the
following test cases to verify the video playback functionality is working as
expected.

## Channels / Streams

Setup:

1. Go to the staging environment URL.
1. Click on any "LIVE" content card which will navigate you to the live channel
   page.

Verify:

- [ ] The channel stream plays in an un-muted state.

### Channel Closed Captions

- [ ] Search for a channel with Closed Captions (official Twitch accounts like
      `twitchgaming` tend to have captions if they are broadcasting an event)
- [ ] Watch the broadcast for a bit until someone speaks a line that would be
      captioned. This is necessary because the caption toggle button will not
      appear until the player tells us that a caption is present in the stream.
      This matches the behavior on Twilight as well.
- [ ] See that the captions button is in the player controls area
- [ ] Press the captions button and see that captions are displayed.

## VODs

Setup:

1. Go to `<staging-url>/videos/960567954`.

Verify:

- [ ] A VOD plays in an un-muted state.
- [ ] Pause / Play and Seeking works as expected.
- [ ] video-play and minute-watched events are emitted (verifiable through
      console logs or space inspector).

### VOD Closed Captions

- [ ] Search for a VOD with Closed Captions (`<staging-url>/videos/999854161`
      seems to work)
- [ ] Seek to a point in the video where captions would appear. This is
      necessary because the caption toggle button will not appear until the
      player tells us that a caption is present in the stream. This matches the
      behavior on Twilight as well.
- [ ] See that the captions button is in the player controls area
- [ ] Press the captions button and see that captions are displayed.

## Clips

Setup:

1. Go to
   `<staging-url>/gabyspartz/clip/DeliciousAntediluvianVanillaStoneLightning-u4flT-0GXweKI3_6`.

Verify:

- [ ] A Clip auto-plays in an un-muted state.
- [ ] Pause / Play and Seeking works as expected.
- [ ] The Clip loops when it ends.
