import { datatype, lorem } from 'faker';
import { convertQueryParamToWholeNumber } from '.';

describe(convertQueryParamToWholeNumber, () => {
  const validNumber = datatype.number();
  it.each`
    param                     | expected
    ${lorem.word()}           | ${null}
    ${''}                     | ${null}
    ${'1.24'}                 | ${null}
    ${'-1'}                   | ${null}
    ${validNumber.toString()} | ${validNumber}
  `('returns $expected when parameter is $param', ({ expected, param }) => {
    expect(convertQueryParamToWholeNumber(param)).toBe(expected);
  });
});
