import { ChatRoot } from 'tachyon-chat-ui';
import { convertToSafeID } from 'tachyon-relay';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { Chat } from '.';

jest.mock('./chat.worker', () => jest.fn());

describe(Chat, () => {
  const setup = createShallowWrapperFactory(Chat, () => ({
    channel: {
      id: convertToSafeID('user', '1234'),
      login: 'therealderekt',
    },
    clientApiId: '12325425453',
    focusIndex: 1,
  }));

  it('renders ChatRoot with a safe channel ID', () => {
    const { props, wrapper } = setup();
    expect(wrapper.find(ChatRoot)).toHaveProp({
      channel: { id: '1234', login: props.channel.login },
    });
  });
});
