import { renderHook } from '@testing-library/react-hooks';
import type { ReactWrapper } from 'enzyme';
import { createMountWrapperFactory, visibility } from 'tachyon-test-utils';
import { AppVisibilityRoot, useAppVisibility, visibleContext } from '.';

const { background, foreground } = visibility(document);
const mockConsumer = jest.fn(() => null);

describe(AppVisibilityRoot, () => {
  let wrapper: ReactWrapper;
  const setup = createMountWrapperFactory(AppVisibilityRoot, () => ({
    children: <visibleContext.Consumer children={mockConsumer} />,
  }));

  afterEach(() => {
    mockConsumer.mockReset();
    wrapper.unmount();
  });

  it('defaults to document visibility', () => {
    foreground();
    ({ wrapper } = setup());

    expect(mockConsumer.mock.calls).toEqual([[true]]);
  });

  it('changes to hidden when document is hidden', () => {
    foreground();
    ({ wrapper } = setup());
    background();

    expect(mockConsumer.mock.calls).toEqual([[true], [false]]);
  });

  it('changes to visible when document is visible', () => {
    background();
    ({ wrapper } = setup());
    foreground();

    expect(mockConsumer.mock.calls).toEqual([[false], [true]]);
  });
});

describe(useAppVisibility, () => {
  it('derives visibility', () => {
    foreground();
    const { result } = renderHook(useAppVisibility, {
      wrapper: AppVisibilityRoot,
    });

    expect(result.current).toEqual(true);
  });
});
