import type { FC } from 'react';
import { useIntl } from 'tachyon-intl';
import { CoreButtonType, CoreText, FontSize, SVGAsset } from 'twitch-core-ui';
import { useTachyonRouter } from '../../../routing';
import type { FocusableTextButtonProps } from '../FocusableTextButton';
import { FocusableTextButton } from '../FocusableTextButton';

type BackButtonProps = Pick<
  FocusableTextButtonProps,
  'withUnfocusBackground'
> & {
  focusIndex: number;
};

// istanbul ignore next: trivial
export const BackButton: FC<BackButtonProps> = ({
  focusIndex,
  ...buttonProps
}) => {
  const { formatMessage } = useIntl();

  // "back" will take the user to the Homepage if they press the button
  // with no previous route history
  const { back } = useTachyonRouter();

  return (
    <FocusableTextButton
      focusIndex={focusIndex}
      focusedType={CoreButtonType.Primary}
      icon={SVGAsset.AngleLeft}
      onClick={back}
      {...buttonProps}
    >
      <CoreText bold fontSize={FontSize.Size5}>
        {formatMessage('Go Back', 'BackButton')}
      </CoreText>
    </FocusableTextButton>
  );
};

BackButton.displayName = 'BackButton';
