import type { FC } from 'react';
import styled from 'styled-components';
import { getBoxArtSrcAndSrcSet } from 'tachyon-more-ui';
import { CoreImage } from 'twitch-core-ui';

const CATEGORY_IMAGE_WIDTH_REM = 10;

// istanbul ignore: trivial
const ScImageContainer = styled.div`
  width: ${CATEGORY_IMAGE_WIDTH_REM}rem;
`;

export interface BannerCategoryImageProps {
  boxArtURL: Parameters<typeof getBoxArtSrcAndSrcSet>[0];
}

// istanbul ignore: trivial
export const BannerCategoryImage: FC<BannerCategoryImageProps> = ({
  boxArtURL,
}) => {
  return (
    <ScImageContainer>
      <CoreImage
        alt=""
        sizes={[{ size: `$CATEGORY_IMAGE_WIDTH_REM}rem` }]}
        {...getBoxArtSrcAndSrcSet(boxArtURL)}
      />
    </ScImageContainer>
  );
};

BannerCategoryImage.displayName = 'BannerCategoryImage';
