import type { PropsWithChildren } from 'react';
import { VerticalShelvesPage } from '../VerticalShelvesPage';
import type { BannerContentBaseProps, BannerProps } from './Banner';
import { Banner } from './Banner';

export { useBannerData } from './useBannerData';

// istanbul ignore next: trivial
/**
 * A component that renders a Banner above the children content, ensuring proper
 * layout compatibility for Chrome 38 and also protecting against performance
 * issues. Banner data can be passed in either via the `staticBannerData` prop
 * for non-dynamic data and via the `updateBannerData` prop (combined with the
 * useBannerData hook) for dynamic data.
 *
 * This component exists to create a static parent component between the upper
 * tree and lower content trees, allowing the upper content to re-render without
 * affecting the lower tree. It also encapsulates the fixed positioning
 * necessary to protect the shelves/rows from moving around the page due to
 * Chrome 38's automatic scroll-into-view behavior for focused elements.
 */
export function BannerPage<
  BannerContentData,
  BannerContentProps extends BannerContentBaseProps<BannerContentData> = BannerContentBaseProps<BannerContentData>,
>({
  children,
  ...props
}: PropsWithChildren<
  BannerProps<BannerContentData, BannerContentProps>
>): JSX.Element {
  return (
    <VerticalShelvesPage>
      <VerticalShelvesPage.ElevatedContent>
        <Banner {...props} />
      </VerticalShelvesPage.ElevatedContent>
      <VerticalShelvesPage.ScrollUnderContent>
        {children}
      </VerticalShelvesPage.ScrollUnderContent>
    </VerticalShelvesPage>
  );
}

BannerPage.displayName = 'BannerPage';
