import { useBannerData } from '.';

const mockUpdater = jest.fn();
const mockRef = { current: mockUpdater };
jest.mock('react', () => ({
  useRef: jest.fn(() => mockRef),
}));

describe(useBannerData, () => {
  beforeEach(() => {
    mockRef.current = mockUpdater;
  });
  const initialData: any = { initial: 'data' };

  it('calls the current updater function when invoked', () => {
    const newData: any = { new: 'data' };
    const updateBannerData = useBannerData(initialData);
    updateBannerData(newData);
    expect(mockUpdater).toHaveBeenCalledWith(newData);
  });

  it('returns initial data via "private" __getInitialData method', () => {
    const updateBannerData = useBannerData(initialData);
    expect(updateBannerData.__getInitialData()).toEqual(initialData);
  });

  it('updates updater function via "private" __setRef method', () => {
    const newUpdater = jest.fn();
    const updateBannerData = useBannerData(initialData);
    expect(mockRef.current).not.toEqual(newUpdater);
    updateBannerData.__setRef(newUpdater);
    expect(mockRef.current).toEqual(newUpdater);
  });
});
