import styled from 'styled-components';
import { backgroundMatchedGradientDark } from 'tachyon-more-ui';

export interface BufferShelfDarkOverlayProps {
  /**
   * The height of the overlay (which can and should extend off-screen for
   * normal TV aspect ratios). This should be equal to the height of the shelf
   * or card row, which also accounting for relevant margins.
   */
  heightRem: number;
  /**
   * The distance from the top of the shelf/row container to the where the
   * partial rows start. This should be equal to height of the shelf/row
   * multiplied by the number of rows, while also accounting for relevant
   * margins.
   */
  verticalOffsetRem: number;
}

function positionOverlay({
  heightRem,
  verticalOffsetRem,
}: BufferShelfDarkOverlayProps): string {
  return `
    height: ${heightRem}rem;
    top: ${verticalOffsetRem}rem;
  `;
}

/**
 * Renders a dark transparent overlay over the non-focused shelf or row to
 * indicate a non-active status and prevent mouse/wand focus and clicks.
 */
export const BufferShelfDarkOverlay = styled.div<BufferShelfDarkOverlayProps>`
  left: 0;
  ${backgroundMatchedGradientDark({ stopPct: 30 })};
  ${positionOverlay}
  opacity: 0.7;
  position: absolute;
  width: 100vw;
`;
