import { createMountWrapperFactory } from 'tachyon-test-utils';
import { BufferShelfDarkOverlay } from '.';

describe('BufferShelfDarkOverlay', () => {
  const setup = createMountWrapperFactory(BufferShelfDarkOverlay, () => ({
    heightRem: 10,
    verticalOffsetRem: 20,
  }));

  it('correctly positions the overlay', () => {
    const { props, wrapper } = setup();
    expect(wrapper).toHaveStyleRule('height', `${props.heightRem}rem`);
    expect(wrapper).toHaveStyleRule('top', `${props.verticalOffsetRem}rem`);
  });
});
