import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { ScFocusableCardImageContainer } from '.';

describe('ScFocusableCardImageContainer', () => {
  const setup = createShallowWrapperFactory(
    ScFocusableCardImageContainer,
    () => ({
      config: {
        cardsPerRow: 1,
        horizontalPaddingRem: 2,
        widthRem: 2,
      },
      focused: false,
    }),
  );

  it('override background color when focused', () => {
    const { wrapper } = setup({ focused: false });
    // Proxy for the full set of non-dynamic properties that are applied
    // since the matcher does not support string sets
    expect(wrapper).not.toHaveStyleRule('transform', expect.any(String));

    wrapper.setProps({ focused: true });
    expect(wrapper).toHaveStyleRule('transform', expect.any(String));
  });

  it('applies border-radius only when provided', () => {
    const { wrapper } = setup({ focused: true });
    // Proxy for the full set of non-dynamic properties that are applied
    // since the matcher does not support string sets
    expect(wrapper).toHaveStyleRule('border-radius', '0rem');

    wrapper.setProps({ borderRadiusRem: 12 });
    expect(wrapper).toHaveStyleRule('border-radius', '12rem');
  });
});
