import type { FC } from 'react';
import { createFragmentContainer, graphql } from 'react-relay/legacy';
import { useTrackedListItem } from 'tachyon-event-tracker';
import { WATCHABLE_CARD_CONFIG } from '../../../config';
import { RouteName, renderTachyonLink } from '../../../routing';
import type { FocusableCardLinkProps } from '../FocusableCardLink';
import { FocusableCardLink } from '../FocusableCardLink';
import { VideoCard } from '../VideoCard';
import type { FocusableClipCard_clip } from './__generated__/FocusableClipCard_clip.graphql';

export type FocusableClipCardProps = Pick<
  FocusableCardLinkProps,
  'focusIndex'
> & {
  clip: FocusableClipCard_clip;
};

// istanbul ignore next: trivial
export const FocusableClipCardBase: FC<FocusableClipCardProps> = ({
  clip,
  focusIndex,
}) => {
  const { interactionContent } = useTrackedListItem(focusIndex);

  const renderLink = renderTachyonLink({
    interactionContent,
    route: RouteName.Clip,
    routeParams: {
      login: clip.broadcaster?.login ?? 'unknown',
      slug: clip.slug,
    },
  });

  return (
    <FocusableCardLink
      config={WATCHABLE_CARD_CONFIG}
      focusIndex={focusIndex}
      renderLink={renderLink}
    >
      <VideoCard
        focusIndex={focusIndex}
        video={{
          createdAt: clip.createdAt,
          game: clip.game
            ? {
                boxArtURL: clip.game.boxArtURL,
                displayName: clip.game.displayName,
              }
            : null,
          lengthSeconds: clip.durationSeconds,
          previewThumbnailURL: clip.thumbnailURL,
          self: null,
          title: clip.title,
          viewCount: clip.viewCount,
        }}
      />
    </FocusableCardLink>
  );
};

FocusableClipCardBase.displayName = 'FocusableClipCardBase';

export const FocusableClipCard = createFragmentContainer(
  FocusableClipCardBase,
  {
    clip: graphql`
      fragment FocusableClipCard_clip on Clip {
        broadcaster {
          login
        }
        createdAt
        durationSeconds
        game {
          boxArtURL
          displayName
        }
        id
        slug
        thumbnailURL
        title
        viewCount
      }
    `,
  },
);

FocusableClipCard.displayName = 'FocusableClipCard';
