import type { FC } from 'react';
import type { SVGAsset } from 'twitch-core-ui';
import {
  AlignItems,
  CoreButtonIcon,
  CoreButtonSize,
  Display,
  Layout,
} from 'twitch-core-ui';
import type { FocusableCoreButtonProps } from '../FocusableCoreButton';
import { FocusableCoreButton } from '../FocusableCoreButton';

export type FocusableIconButtonProps = Omit<
  FocusableCoreButtonProps,
  'size'
> & {
  'aria-label': string;
  icon: SVGAsset;
};

export const FocusableIconButton: FC<FocusableIconButtonProps> = ({
  icon,
  ...buttonProps
}) => {
  return (
    <FocusableCoreButton size={CoreButtonSize.Large} {...buttonProps}>
      <Layout
        alignItems={AlignItems.Center}
        display={Display.Flex}
        padding={{ x: 0.5 }}
      >
        <CoreButtonIcon icon={icon} size={CoreButtonSize.Large} />
      </Layout>
    </FocusableCoreButton>
  );
};

FocusableIconButton.displayName = 'FocusableIconButton';
