import type { FC } from 'react';
import styled from 'styled-components';
import { refFocusHandler, useFocus } from 'tachyon-tv-nav';
import type { CoreLinkProps } from 'twitch-core-ui';
import { CoreLink, CoreLinkType } from 'twitch-core-ui';
import { DarkThemeMap } from 'twitch-core-ui-tokens';

type ScCoreLinkProps = Omit<CoreLinkProps, 'type'>;

// istanbul ignore next: trivial
const ScCoreLink = styled((props: Omit<CoreLinkProps, 'type'>) => (
  <CoreLink variant={CoreLinkType.Inherit} {...props} />
))`
  &:focus {
    color: ${DarkThemeMap['color-text-link-focus']};
  }
`;

type FocusableLinkProps = ScCoreLinkProps & {
  focusIndex: number;
};

// istanbul ignore next: trivial
export const FocusableLink: FC<FocusableLinkProps> = ({
  focusIndex,
  ...linkProps
}) => {
  const { focused, takeFocus } = useFocus(focusIndex);
  return (
    <ScCoreLink
      onMouseEnter={takeFocus}
      refHandler={refFocusHandler(focused)}
      {...linkProps}
    />
  );
};

FocusableLink.displayName = 'FocusableLink';
