import type { FC } from 'react';
import { useIntl } from 'tachyon-intl';
import { SVGAsset } from 'twitch-core-ui';
import { RouteName, renderTachyonLink } from '../../../routing';
import type { FocusableCoreButtonProps } from '../FocusableCoreButton';
import { FocusableTextButton } from '../FocusableTextButton';

export type FocusableReportButtonProps = FocusableCoreButtonProps & {
  login: string;
};

// istanbul ignore next: trivial
export const FocusableReportButton: FC<FocusableReportButtonProps> = ({
  login,
  ...props
}) => {
  const { formatMessage } = useIntl();

  return (
    <FocusableTextButton
      icon={SVGAsset.Report}
      linkTo="/deferToRenderLink"
      renderLink={renderTachyonLink({
        route: RouteName.SettingsChannelReport,
        routeParams: {
          login,
        },
      })}
      {...props}
    >
      {formatMessage('Report', 'FocusableReportButton')}
    </FocusableTextButton>
  );
};
FocusableReportButton.displayName = 'ReportButton';
