import type { FC, ReactNode } from 'react';
import type { SVGAsset } from 'twitch-core-ui';
import { CoreButtonLabel, CoreButtonSize } from 'twitch-core-ui';
import type { FocusableCoreButtonProps } from '../FocusableCoreButton';
import { FocusableCoreButton } from '../FocusableCoreButton';

export type FocusableTextButtonProps = Omit<
  FocusableCoreButtonProps,
  'size'
> & {
  children: ReactNode;
  icon?: SVGAsset;
};

// istanbul ignore next: trivial
/**
 * Renders a focusable button that contains text and an optional icon.
 */
export const FocusableTextButton: FC<FocusableTextButtonProps> = ({
  children,
  icon,
  ...buttonProps
}) => {
  return (
    <FocusableCoreButton size={CoreButtonSize.Large} {...buttonProps}>
      <CoreButtonLabel
        children={children}
        icon={icon}
        size={CoreButtonSize.Large}
      />
    </FocusableCoreButton>
  );
};

FocusableTextButton.displayName = 'FocusableButton';
