import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { Input, InputType } from 'twitch-core-ui';
import { FocusableTextInput, ScTextInputWrapper } from '.';

jest.mock('tachyon-tv-nav', () => ({
  ...jest.requireActual('tachyon-tv-nav'),
  useFocus: jest.fn(() => ({ focused: true })),
}));

describe(FocusableTextInput, () => {
  const setup = createShallowWrapperFactory(FocusableTextInput, () => ({
    focusIndex: 0,
    onSubmit: jest.fn(),
    type: InputType.Text,
  }));

  it('does not call onSubmit on enter for an empty term', () => {
    const { props, wrapper } = setup();
    wrapper
      .find(Input)
      .simulate('keydown', { currentTarget: { key: 'Enter' } });

    expect(props.onSubmit).not.toHaveBeenCalled();
  });

  it('invokes onSubmit with the search term on enter key press', () => {
    const { props, wrapper } = setup();

    wrapper
      .find(Input)
      .simulate('change', { currentTarget: { value: 'therealderekt' } });
    wrapper.update();

    wrapper.find(Input).simulate('keydown', { key: 'Enter' });

    expect(props.onSubmit).toHaveBeenCalledTimes(1);
    expect(props.onSubmit).toHaveBeenCalledWith('therealderekt');
  });

  it('passes through other props to the input', () => {
    const { props, wrapper } = setup({ onFocus: () => undefined });
    expect(wrapper.find(Input)).toHaveProp({ onFocus: props.onFocus });
  });
});

describe('ScTextInputWrapper', () => {
  const setup = createShallowWrapperFactory(ScTextInputWrapper, () => ({
    $focused: true,
  }));

  it('has border set when focused', () => {
    const { wrapper } = setup();
    expect(wrapper).toHaveStyleRule('border');
  });

  it('does not have border set when not focused', () => {
    const { wrapper } = setup({ $focused: false });
    expect(wrapper).not.toHaveStyleRule('border');
  });
});
