import { GridNav } from 'tachyon-tv-nav';
import type { CardConfig } from '../../../config';
import {
  CARD_ANIMATION_TIMING_S,
  GRID_CARD_BOTTOM_MARGIN_REM,
  GRID_CARD_HEIGHT_REM,
} from '../../../config';
import { BufferShelfDarkOverlay } from '../BufferShelfDarkOverlay';
import type { MovableListProps } from '../MovableList';
import { MovableList } from '../MovableList';

export type FocusableTowerProps<T> = Pick<
  MovableListProps<T>,
  'itemRenderer' | 'items'
> & {
  config: CardConfig;
  focusIndex: number;
  fullOnScreenCardRows: number;
};

/**
 * A virtualized grid of navigable items.
 */
export function FocusableTower<T>({
  config,
  focusIndex,
  fullOnScreenCardRows,
  itemRenderer,
  items,
}: FocusableTowerProps<T>): JSX.Element {
  // subtract margin to ensure cards can't peak over the top of the overlay
  const bufferOffset =
    GRID_CARD_HEIGHT_REM * fullOnScreenCardRows - GRID_CARD_BOTTOM_MARGIN_REM;
  // re-add margin here to ensure full card coverage
  const bufferHeight = GRID_CARD_HEIGHT_REM + GRID_CARD_BOTTOM_MARGIN_REM;

  return (
    <>
      <GridNav
        elementCount={items.length}
        elementsPerRow={config.cardsPerRow}
        focusIndex={focusIndex}
        handleWheel
        takeFocusOnFirstRender
      >
        <MovableList
          direction="vertical-grid"
          elementsPerLine={config.cardsPerRow}
          itemRenderer={itemRenderer}
          items={items}
          leadingBufferLines={1}
          lineSizeRem={GRID_CARD_HEIGHT_REM}
          trailingBufferLines={1}
          transitionDurationS={CARD_ANIMATION_TIMING_S}
          verticalWidthVw={100}
          visibleLines={fullOnScreenCardRows}
        />
      </GridNav>
      <BufferShelfDarkOverlay
        heightRem={bufferHeight}
        verticalOffsetRem={bufferOffset}
      />
    </>
  );
}

FocusableTower.displayName = 'FocusableTower';
