import type { FC } from 'react';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { MovableList } from '../MovableList';
import type { FocusableTowerProps } from '.';
import { FocusableTower } from '.';

const MockCard: FC<{ item: string }> = ({ item }) => <div>{item}</div>;

describe(FocusableTower, () => {
  const setup = createShallowWrapperFactory<FocusableTowerProps<string>>(
    FocusableTower,
    () => ({
      config: {
        cardsPerRow: 2,
        horizontalPaddingRem: 1,
        widthRem: 3,
      },
      focusIndex: 0,
      fullOnScreenCardRows: 3,
      itemRenderer: (item: string, _: number) => <MockCard item={item} />,
      items: ['foo', 'bar', 'baz'],
    }),
  );

  it('renders all of the provided items', () => {
    const { props, wrapper } = setup();
    expect(wrapper.find(MovableList).prop('items')).toHaveLength(
      props.items.length,
    );
  });
});
