import type { FC } from 'react';
import { createFragmentContainer, graphql } from 'react-relay/legacy';
import { useTrackedListItem } from 'tachyon-event-tracker';
import { WATCHABLE_CARD_CONFIG } from '../../../config';
import { RouteName, renderTachyonLink } from '../../../routing';
import type { FocusableCardLinkProps } from '../FocusableCardLink';
import { FocusableCardLink } from '../FocusableCardLink';
import { VideoCard } from '../VideoCard';
import type { FocusableVodCard_video } from './__generated__/FocusableVodCard_video.graphql';

export type FocusableVodCardProps = Pick<
  FocusableCardLinkProps,
  'focusIndex' | 'onClick' | 'onFocus'
> & {
  video: FocusableVodCard_video;
};

// istanbul ignore next: trivial
export const FocusableVodCardBase: FC<FocusableVodCardProps> = ({
  focusIndex,
  onClick,
  onFocus,
  video,
}) => {
  const { interactionContent } = useTrackedListItem(focusIndex);

  const renderLink = renderTachyonLink({
    interactionContent,
    route: RouteName.Vod,
    routeParams: {
      id: video.id,
    },
  });

  return (
    <FocusableCardLink
      config={WATCHABLE_CARD_CONFIG}
      focusIndex={focusIndex}
      onClick={onClick}
      onFocus={onFocus}
      renderLink={renderLink}
    >
      <VideoCard focusIndex={focusIndex} video={video} />
    </FocusableCardLink>
  );
};

FocusableVodCardBase.displayName = 'FocusableVodCardBase';

export const FocusableVodCard = createFragmentContainer(FocusableVodCardBase, {
  video: graphql`
    fragment FocusableVodCard_video on Video {
      createdAt
      lengthSeconds
      game {
        boxArtURL
        displayName
      }
      id
      previewThumbnailURL
      self {
        viewingHistory {
          position
        }
      }
      title
      viewCount
    }
  `,
});

FocusableVodCard.displayName = 'FocusableVodCard';
