import type { FC } from 'react';
import styled from 'styled-components';
import type { AvatarProps } from 'tachyon-more-ui';
import {
  Avatar,
  StreamType,
  StreamTypeIndicator,
  getStreamAccentColor,
  squareSize,
} from 'tachyon-more-ui';
import { StaticTokenMap } from 'twitch-core-ui-tokens';

// As of Core-UI 15.1.2 this component does not exist in the library. We can replace
// this once it is supported.
// enzyme does not support pseudo-selectors for before. Nothing to test here.
const ScAvatarGradientContainer = styled.div<{
  color: string;
}>`
  position: relative;
  figure {
    padding: 0.25rem;
    &::before {
      background: linear-gradient(
        to top,
        ${StaticTokenMap['color-white']} 10%,
        ${({ color }) => color} 35%
      );
      border-radius: 50%;
      box-sizing: border-box;
      content: '';
      left: 0;
      ${squareSize({ sizePct: 100 })}
      position: absolute;
      top: 0;
      z-index: -1;
    }
  }

  img {
    background-color: ${StaticTokenMap['color-hinted-grey-1']};
    border: 0.25rem solid ${StaticTokenMap['color-hinted-grey-1']};
    border-radius: 50% !important;
  }
`;

const ScChannelStatusTextIndicatorWrapper = styled.div`
  border: solid 0.25rem ${StaticTokenMap['color-hinted-grey-1']};
  bottom: -1rem;
  left: 50%;
  position: absolute;
  transform: translateX(-50%);
  p {
    text-transform: none !important;
  }
`;

type GradientAvatarProps = {
  login: string;
  profileImageURL: AvatarProps['src'];
  streamType: StreamType | undefined;
  streamerPrimaryColorHex: Parameters<typeof getStreamAccentColor>[0];
};

export const GradientAvatar: FC<GradientAvatarProps> = ({
  login,
  profileImageURL,
  streamType,
  streamerPrimaryColorHex,
}) => (
  <ScAvatarGradientContainer
    color={getStreamAccentColor(streamerPrimaryColorHex)}
  >
    <Avatar alt="" sizeRem={6.5} src={profileImageURL} userLogin={login} />
    <ScChannelStatusTextIndicatorWrapper>
      {streamType === StreamType.Live && (
        <StreamTypeIndicator
          isOverlay={false}
          isPulsing={false}
          streamType={streamType}
        />
      )}
    </ScChannelStatusTextIndicatorWrapper>
  </ScAvatarGradientContainer>
);

GradientAvatar.displayName = 'BottomControlsAvatar';
