import type { FC } from 'react';
import styled from 'styled-components';
import { Layout, Title, TitleSize } from 'twitch-core-ui';
import { CARD_HEIGHT_REM, OVERSCAN_PADDING_REM } from '../../../../config';

const TITLE_HEIGHT_REM = 2;
const TITLE_SHELF_SPACE_REM = 2;
const BOTTOM_PADDING_REM = 0.5;

export const SHELF_FRAME_HEIGHT_REM =
  TITLE_HEIGHT_REM +
  TITLE_SHELF_SPACE_REM +
  CARD_HEIGHT_REM +
  BOTTOM_PADDING_REM;

// istanbul ignore next: trivial
/**
 * Left / right padding need to be exactly the OVERSCAN_PADDING_REM value
 * for the card pixel math in config/ui.ts to work properly.
 */
const ScSection = styled.section`
  height: ${SHELF_FRAME_HEIGHT_REM}rem;
  overflow: visible;
  padding: 0 ${OVERSCAN_PADDING_REM}rem ${BOTTOM_PADDING_REM}rem
    ${OVERSCAN_PADDING_REM}rem;
  position: relative;
  width: 100vw;
`;

const ScTitle = styled(Title)`
  height: ${TITLE_HEIGHT_REM}rem;
`;

export type ShelfFrameProps = {
  title: string;
};

// istanbul ignore next: trivial
export const ShelfFrame: FC<ShelfFrameProps> = ({ children, title }) => (
  <ScSection>
    <ScTitle size={TitleSize.ExtraSmall}>{title}</ScTitle>
    <Layout margin={{ top: TITLE_SHELF_SPACE_REM }}>{children}</Layout>
  </ScSection>
);

ShelfFrame.displayName = 'ShelfFrame';
