import { createMountWrapperFactory } from 'tachyon-test-utils';
import { useAreaChildFocusIndex } from 'tachyon-tv-nav';
import { useWandActivity } from '../../../framework';
import { ShelfPageButtons } from '.';

jest.mock('tachyon-tv-nav', () => ({
  useAreaChildFocusIndex: jest.fn(),
}));

jest.mock('../../../framework', () => ({
  useWandActivity: jest.fn(),
}));

const mockUseAreaChildFocusIndex = useAreaChildFocusIndex as jest.Mock;
const mockUseWandActivity = useWandActivity as jest.Mock;

describe(ShelfPageButtons, () => {
  const setup = createMountWrapperFactory(ShelfPageButtons, () => ({
    next: true,
    prev: true,
  }));

  beforeEach(() => {
    mockUseAreaChildFocusIndex.mockReturnValue(0);
    mockUseWandActivity.mockReturnValue(true);
  });

  it('does not render if the wand is inactive', () => {
    mockUseWandActivity.mockReturnValue(false);
    const { wrapper } = setup();
    expect(wrapper).toBeEmptyRender();
  });

  it('disables the left arrow if prev is not set', () => {
    const { wrapper } = setup({ prev: false });
    expect(wrapper.find('button').first()).toHaveProp({ disabled: true });
  });

  it('enables the left arrow if prev is set', () => {
    const { wrapper } = setup({ prev: true });
    expect(wrapper.find('button').first()).toHaveProp({ disabled: false });
  });

  it('disables the right arrow if next is not set', () => {
    const { wrapper } = setup({ next: false });
    expect(wrapper.find('button').at(1)).toHaveProp({ disabled: true });
  });

  it('enables the right arrow if next is set', () => {
    const { wrapper } = setup({ next: true });
    expect(wrapper.find('button').at(1)).toHaveProp({ disabled: false });
  });
});
