import type { HorizontalShelfProps } from '.';

/**
 * Mock for integration testing provided item / rendered behavior. Use via:
 *
 * jest.mock('../../common/HorizontalShelf', () => {
 *   const { MockHorizontalShelf } = jest.requireActual(
 *     '../../common/HorizontalShelf/test-mocks',
 *   );
 *   return { HorizontalShelf: MockHorizontalShelf };
 * });
 */
export function MockHorizontalShelf<T>({
  itemRenderer,
  items,
}: HorizontalShelfProps<T>): JSX.Element {
  return <div>{items.map(itemRenderer)}</div>;
}

MockHorizontalShelf.displayName = 'MockHorizontalShelf';
