import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { useFocus } from 'tachyon-tv-nav';
import { MovableList } from '..';
import { ShelfPageButtons } from './ShelfPageButtons';
import { HorizontalShelf } from '.';

jest.mock('tachyon-tv-nav', () => ({
  ...jest.requireActual('tachyon-tv-nav'),
  useFocus: jest.fn(() => ({ focused: true })),
}));

const mockUseFocus = useFocus as jest.Mock;

describe(HorizontalShelf, () => {
  const setup = createShallowWrapperFactory(HorizontalShelf, () => ({
    active: true,
    config: {
      cardsPerRow: 3,
      horizontalPaddingRem: 1,
      widthRem: 1,
    },
    focusIndex: 0,
    itemRenderer: jest.fn(),
    items: [1],
    showButtons: false,
    takeFocusOnFirstRender: false,
    title: 'Shelf',
  }));

  describe('shelf buttons', () => {
    it('renders when the shelf is focused', () => {
      mockUseFocus.mockReturnValue({ focused: true });
      const { wrapper } = setup();
      const overlayRenderer = wrapper.find(MovableList).prop('overlayRenderer');

      expect(overlayRenderer!([0, 1])).toEqual(
        <ShelfPageButtons next={false} prev />,
      );
    });

    it('prev enabled when the visibleRange does not include the first item', () => {
      mockUseFocus.mockReturnValue({ focused: true });
      const { wrapper } = setup();
      const overlayRenderer = wrapper.find(MovableList).prop('overlayRenderer');

      expect(overlayRenderer!([0, 1])).toEqual(
        <ShelfPageButtons next={false} prev />,
      );
    });

    it('next enabled when the visibleRange does not include the last item', () => {
      mockUseFocus.mockReturnValue({ focused: true });
      const { wrapper } = setup({ items: [1, 2, 3] });
      const overlayRenderer = wrapper.find(MovableList).prop('overlayRenderer');

      expect(overlayRenderer!([1, 2])).toEqual(<ShelfPageButtons next prev />);
    });

    it('does not render when the shelf is unfocused', () => {
      mockUseFocus.mockReturnValue({ focused: false });
      const { wrapper } = setup();
      const overlayRenderer = wrapper.find(MovableList).prop('overlayRenderer');

      expect(overlayRenderer!([])).toBe(false);
    });
  });
});
