import type { FC } from 'react';
import { graphql, useFragment } from 'react-relay/hooks';
import styled from 'styled-components';
import { useIntl } from 'tachyon-intl';
import { getFormattedUserDisplayName } from 'tachyon-utils';
import { CoreText, FontSize, FontWeight, Layout } from 'twitch-core-ui';
import type { ChannelDescription_channel$key } from './__generated__/ChannelDescription_channel.graphql';

const channelDescriptionFragment = graphql`
  fragment ChannelDescription_channel on User {
    description
    displayName
    login
  }
`;

// istanbul ignore next: trivial
export const ScDescriptionContainer = styled.div`
  height: 3.5rem;
  margin-top: 0.5rem;
`;

export type ChannelDescriptionProps = {
  channel: ChannelDescription_channel$key | null;
};

export const ChannelDescription: FC<ChannelDescriptionProps> = ({
  channel: channelRef,
}) => {
  const channel = useFragment(channelDescriptionFragment, channelRef);
  const { formatMessage } = useIntl();
  if (!channel || !channel.description) {
    return null;
  }
  const name = getFormattedUserDisplayName(channel);
  return (
    <Layout margin={{ top: 2 }}>
      <CoreText fontSize={FontSize.Size8} fontWeight={FontWeight.SemiBold}>
        {formatMessage(
          'About {broadcasterName}:',
          { broadcasterName: name },
          'InterstitialLayout',
        )}
      </CoreText>
      <ScDescriptionContainer>
        <CoreText ellipsis fontSize={FontSize.Size8} lines={2}>
          {channel.description}
        </CoreText>
      </ScDescriptionContainer>
    </Layout>
  );
};
ChannelDescription.displayName = 'InterstitialChannelDescription';
