import { internet, lorem } from 'faker';
import { useFragment } from 'react-relay/hooks';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { ChannelDescription, ScDescriptionContainer } from '.';

jest.mock('react-relay/hooks', () => ({
  ...jest.requireActual('react-relay/hooks'),
  useFragment: jest.fn(),
}));
const mockUseFragment = useFragment as jest.Mock;

describe(ChannelDescription, () => {
  beforeEach(() => {
    mockUseFragment.mockReset();
  });
  const mockUser = {
    description: null,
    displayName: internet.userName(),
    login: internet.userName(),
  };

  const setup = createShallowWrapperFactory(ChannelDescription, () => ({
    channel: {} as any,
  }));

  it('renders a description if one exists', () => {
    mockUseFragment.mockImplementationOnce(() => ({
      ...mockUser,
      description: lorem.paragraph(),
    }));
    const { wrapper } = setup();
    expect(wrapper.find(ScDescriptionContainer)).toExist();
  });

  it('does not render a description if none exists', () => {
    mockUseFragment.mockImplementationOnce(() => mockUser);
    const { wrapper } = setup();
    expect(wrapper.find(ScDescriptionContainer)).not.toExist();
  });
});
