import type { FC } from 'react';
import styled from 'styled-components';
import { useIntl } from 'tachyon-intl';
import { getBoxArtSrcAndSrcSet } from 'tachyon-more-ui';
import { formatVideoLength } from 'tachyon-utils';
import {
  CoreImage,
  CoreText,
  Display,
  FlexDirection,
  FontWeight,
  JustifyContent,
  Layout,
  TextType,
  WhiteSpace,
} from 'twitch-core-ui';

// istanbul ignore next: trivial
const ScTextLayout = styled(Layout)`
  margin-bottom: 0.5rem;
`;

// istanbul ignore next: trivial
export const ScListContainer = styled.div`
  margin-top: 0.5rem;
`;

export type InterstitialVideoDetailsProps = {
  categoryImageURL?: string | null;
  categoryName?: string;
  createdAt: string | null;
  videoDuration: number | null;
  videoTitle: string | null;
};

export const InterstitialVideoDetails: FC<InterstitialVideoDetailsProps> = ({
  categoryImageURL,
  categoryName,
  createdAt,
  videoDuration,
  videoTitle,
}) => {
  const { formatPastRelativeDate } = useIntl();
  let clipDuration = '';
  let relativeDate = '';
  if (videoDuration) {
    clipDuration = formatVideoLength(videoDuration);
  }
  if (createdAt) {
    relativeDate = formatPastRelativeDate(new Date(createdAt));
  }
  return (
    <Layout display={Display.Flex} flexDirection={FlexDirection.Row}>
      {categoryImageURL && (
        <Layout margin={{ right: 2 }}>
          <CoreImage
            alt=""
            sizes={[{ size: `7rem` }]}
            {...getBoxArtSrcAndSrcSet(categoryImageURL)}
          />
        </Layout>
      )}
      <Layout
        display={Display.Flex}
        flexDirection={FlexDirection.Column}
        justifyContent={JustifyContent.Center}
      >
        {videoTitle && (
          <ScTextLayout>
            <CoreText fontWeight={FontWeight.SemiBold} type={TextType.H6}>
              {videoTitle}
            </CoreText>
          </ScTextLayout>
        )}
        {categoryName && (
          <ScTextLayout>
            <CoreText type={TextType.H6}>{categoryName}</CoreText>
          </ScTextLayout>
        )}
        {(clipDuration || relativeDate) && (
          <ScTextLayout
            display={Display.Flex}
            flexDirection={FlexDirection.Row}
          >
            <CoreText type={TextType.H6}>{clipDuration}</CoreText>
            {clipDuration && relativeDate && (
              <CoreText type={TextType.H6} whiteSpace={WhiteSpace.PreWrap}>
                {' • '}
              </CoreText>
            )}
            <CoreText type={TextType.H6}>{relativeDate}</CoreText>
          </ScTextLayout>
        )}
      </Layout>
    </Layout>
  );
};

InterstitialVideoDetails.displayName = 'InterstitialVideoDetails';
