import { date, image, internet, lorem } from 'faker';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { InterstitialVideoDetails } from '.';

describe(InterstitialVideoDetails, () => {
  const setup = createShallowWrapperFactory(InterstitialVideoDetails, () => ({
    categoryImageURL: image.imageUrl(),
    categoryName: internet.userName(),
    createdAt: date.past().toISOString(),
    videoDuration: 30,
    videoTitle: lorem.words(4),
  }));

  it('renders a spacer if duration and createdAt exist', () => {
    const { wrapper } = setup();
    expect(wrapper.find({ children: ' • ' })).toExist();
  });

  it('does not render a spacer if only one of duration and createdAt exists', () => {
    const { wrapper } = setup({ createdAt: undefined });
    expect(wrapper.find({ children: ' • ' })).not.toExist();
  });
});
