import type { FC } from 'react';
import {
  AlignItems,
  Display,
  JustifyContent,
  Layout,
  LoadingSpinner,
  Position,
} from 'twitch-core-ui';
import { LOADING_SHOW_DELAY_MS } from '../../../config';
import { StarshotMain } from '../StarshotMain';

// istanbul ignore next: trivial
export const LoadingContent: FC = () => (
  <Layout
    alignItems={AlignItems.Center}
    attachBottom
    attachLeft
    attachRight
    attachTop
    display={Display.Flex}
    justifyContent={JustifyContent.Center}
    position={Position.Absolute}
  >
    <LoadingSpinner delay={LOADING_SHOW_DELAY_MS} />
  </Layout>
);

LoadingContent.displayName = 'LoadingContent';

export const FullScreenLoadingContent: FC = () => (
  <StarshotMain>
    <LoadingContent />
  </StarshotMain>
);

FullScreenLoadingContent.displayName = 'FullScreenLoadingContent';
