import type { ScScrollContainerProps } from '.';
import { getSpacingSizes } from '.';

describe('ScScrollContainer utils', () => {
  const lineSizeRem = 5;

  describe(getSpacingSizes, () => {
    it('is zeroes for first line without leading buffer', () => {
      expect(
        getSpacingSizes({
          leadingBufferLines: 0,
          lineSizeRem,
          offsetLineCount: 0,
        } as ScScrollContainerProps),
      ).toEqual({ marginRem: 0, paddingRem: 0 });
    });

    it('is zeroes for first line with leading buffer', () => {
      expect(
        getSpacingSizes({
          leadingBufferLines: 1,
          lineSizeRem,
          offsetLineCount: 0,
        } as ScScrollContainerProps),
      ).toEqual({ marginRem: 0, paddingRem: 0 });
    });

    it('is matching for second line without leading buffer', () => {
      expect(
        getSpacingSizes({
          leadingBufferLines: 0,
          lineSizeRem,
          offsetLineCount: 1,
        } as ScScrollContainerProps),
      ).toEqual({ marginRem: 5, paddingRem: 5 });
    });

    it('is zero padding for first line with leading buffer', () => {
      expect(
        getSpacingSizes({
          leadingBufferLines: 1,
          lineSizeRem,
          offsetLineCount: 1,
        } as ScScrollContainerProps),
      ).toEqual({ marginRem: 5, paddingRem: 0 });
    });
  });
});
