import type { VisibleRange, VisibleRangeBaseOpts } from '../types';

export interface GetOffsetLineCountOpts
  extends Omit<VisibleRangeBaseOpts, 'trailingBufferLines'> {
  /**
   * The current VisibleRange array.
   */
  currentVisibleRange: VisibleRange;
}

export function getOffsetLineCount({
  currentVisibleRange,
  elementsPerLine,
  leadingBufferLines = 0,
}: GetOffsetLineCountOpts): number {
  return currentVisibleRange[0] / elementsPerLine + leadingBufferLines;
}
