import { getOffsetLineCount } from '.';

describe(getOffsetLineCount, () => {
  describe('without buffer lines', () => {
    it('works on straight line with no offset', () => {
      expect(
        getOffsetLineCount({
          currentVisibleRange: [0, 1, 2, 3],
          elementsPerLine: 1,
        }),
      ).toEqual(0);
    });

    it('works on straight line with offset', () => {
      // lines 1 and 2 are virtualized
      expect(
        getOffsetLineCount({
          currentVisibleRange: [2, 3, 4, 5],
          elementsPerLine: 1,
        }),
      ).toEqual(2);
    });

    it('works on grid with no offset', () => {
      expect(
        getOffsetLineCount({
          currentVisibleRange: [0, 1, 2, 3],
          elementsPerLine: 2,
        }),
      ).toEqual(0);
    });

    it('works on grid with offset', () => {
      // line 1 is virtualized
      expect(
        getOffsetLineCount({
          currentVisibleRange: [2, 3, 4, 5],
          elementsPerLine: 2,
        }),
      ).toEqual(1);
    });
  });

  describe('with buffer lines', () => {
    const leadingBufferLines = 1;

    it('works on straight line with no offset', () => {
      expect(
        getOffsetLineCount({
          currentVisibleRange: [-1, 0, 1, 2, 3, 4],
          elementsPerLine: 1,
          leadingBufferLines,
        }),
      ).toEqual(0);
    });

    it('works on straight line with offset', () => {
      expect(
        getOffsetLineCount({
          currentVisibleRange: [1, 2, 3, 4, 5, 6],
          elementsPerLine: 1,
          leadingBufferLines,
        }),
      ).toEqual(2);
    });

    it('works on grid with no offset', () => {
      expect(
        getOffsetLineCount({
          currentVisibleRange: [-2, -1, 0, 1, 2, 3, 4, 5],
          elementsPerLine: 2,
          leadingBufferLines,
        }),
      ).toEqual(0);
    });

    it('works on grid with offset', () => {
      expect(
        getOffsetLineCount({
          currentVisibleRange: [0, 1, 2, 3, 4, 5, 6, 7],
          elementsPerLine: 2,
          leadingBufferLines,
        }),
      ).toEqual(1);
    });
  });
});
