import type { VisibleRange, VisibleRangeBaseOpts } from '../types';

type ShouldVisibleRangeChangeOpts = VisibleRangeBaseOpts & {
  newFocusIndex: number;
  visibleRange: VisibleRange;
};

/**
 * Determines whether the focus index has moved outside of the current "window"
 * of non-buffer items within the range between the trailing and leading buffers
 */
export function shouldVisibleRangeChange({
  elementsPerLine,
  leadingBufferLines = 0,
  newFocusIndex,
  trailingBufferLines = 0,
  visibleRange,
}: ShouldVisibleRangeChangeOpts): boolean {
  const firstNonbufferIndex =
    visibleRange[elementsPerLine * leadingBufferLines];

  const lastNonbufferIndex =
    visibleRange[
      visibleRange.length - 1 - elementsPerLine * trailingBufferLines
    ];

  return (
    newFocusIndex < firstNonbufferIndex || lastNonbufferIndex < newFocusIndex
  );
}
