import { shouldVisibleRangeChange } from '.';

describe(shouldVisibleRangeChange, () => {
  // default convenience values
  const leadingBufferLines = 1;
  const trailingBufferLines = 1;
  const visibleRange = [2, 3, 4, 5, 6, 7];

  describe('without buffers', () => {
    describe('for straight line', () => {
      const elementsPerLine = 1;
      it('returns false when in range (at start)', () => {
        expect(
          shouldVisibleRangeChange({
            elementsPerLine,
            newFocusIndex: 2,
            visibleRange,
          }),
        ).toBeFalsy();
      });

      it('returns false when in range (at end)', () => {
        expect(
          shouldVisibleRangeChange({
            elementsPerLine,
            newFocusIndex: 7,
            visibleRange,
          }),
        ).toBeFalsy();
      });

      it('returns true when below range', () => {
        expect(
          shouldVisibleRangeChange({
            elementsPerLine,
            newFocusIndex: 1,
            visibleRange,
          }),
        ).toBeTruthy();
      });

      it('returns true when above range', () => {
        expect(
          shouldVisibleRangeChange({
            elementsPerLine,
            newFocusIndex: 8,
            visibleRange,
          }),
        ).toBeTruthy();
      });
    });

    describe('for grid', () => {
      const elementsPerLine = 2;
      it('returns false when in range (at start)', () => {
        expect(
          shouldVisibleRangeChange({
            elementsPerLine,
            newFocusIndex: 2,
            visibleRange,
          }),
        ).toBeFalsy();
      });

      it('returns false when in range (at end)', () => {
        expect(
          shouldVisibleRangeChange({
            elementsPerLine,
            newFocusIndex: 7,
            visibleRange,
          }),
        ).toBeFalsy();
      });

      it('returns true when below range', () => {
        expect(
          shouldVisibleRangeChange({
            elementsPerLine,
            newFocusIndex: 1,
            visibleRange,
          }),
        ).toBeTruthy();
      });

      it('returns true when above range', () => {
        expect(
          shouldVisibleRangeChange({
            elementsPerLine,
            newFocusIndex: 8,
            visibleRange,
          }),
        ).toBeTruthy();
      });
    });
  });

  describe('with buffers', () => {
    describe('for straight line', () => {
      const elementsPerLine = 1;
      it('returns false when in range (at start)', () => {
        expect(
          shouldVisibleRangeChange({
            elementsPerLine,
            leadingBufferLines,
            newFocusIndex: 3,
            trailingBufferLines,
            visibleRange,
          }),
        ).toBeFalsy();
      });

      it('returns false when in range (at end)', () => {
        expect(
          shouldVisibleRangeChange({
            elementsPerLine,
            leadingBufferLines,
            newFocusIndex: 6,
            trailingBufferLines,
            visibleRange,
          }),
        ).toBeFalsy();
      });

      it('returns true in leading buffer', () => {
        expect(
          shouldVisibleRangeChange({
            elementsPerLine,
            leadingBufferLines,
            newFocusIndex: 2,
            trailingBufferLines,
            visibleRange,
          }),
        ).toBeTruthy();
      });

      it('returns true when below range', () => {
        expect(
          shouldVisibleRangeChange({
            elementsPerLine,
            leadingBufferLines,
            newFocusIndex: 1,
            trailingBufferLines,
            visibleRange,
          }),
        ).toBeTruthy();
      });

      it('returns true when in trailing buffer', () => {
        expect(
          shouldVisibleRangeChange({
            elementsPerLine,
            leadingBufferLines,
            newFocusIndex: 7,
            trailingBufferLines,
            visibleRange,
          }),
        ).toBeTruthy();
      });

      it('returns true when above range', () => {
        expect(
          shouldVisibleRangeChange({
            elementsPerLine,
            leadingBufferLines,
            newFocusIndex: 8,
            trailingBufferLines,
            visibleRange,
          }),
        ).toBeTruthy();
      });
    });

    describe('for grid', () => {
      const elementsPerLine = 2;
      it('returns false when in range (at start)', () => {
        expect(
          shouldVisibleRangeChange({
            elementsPerLine,
            leadingBufferLines,
            newFocusIndex: 4,
            trailingBufferLines,
            visibleRange,
          }),
        ).toBeFalsy();
      });

      it('returns false when in range (at end)', () => {
        expect(
          shouldVisibleRangeChange({
            elementsPerLine,
            leadingBufferLines,
            newFocusIndex: 5,
            trailingBufferLines,
            visibleRange,
          }),
        ).toBeFalsy();
      });

      it('returns true when in leading buffer', () => {
        expect(
          shouldVisibleRangeChange({
            elementsPerLine,
            leadingBufferLines,
            newFocusIndex: 3,
            trailingBufferLines,
            visibleRange,
          }),
        ).toBeTruthy();
      });

      it('returns true when below range', () => {
        expect(
          shouldVisibleRangeChange({
            elementsPerLine,
            leadingBufferLines,
            newFocusIndex: 1,
            trailingBufferLines,
            visibleRange,
          }),
        ).toBeTruthy();
      });

      it('returns true when in trailing buffer', () => {
        expect(
          shouldVisibleRangeChange({
            elementsPerLine,
            leadingBufferLines,
            newFocusIndex: 6,
            trailingBufferLines,
            visibleRange,
          }),
        ).toBeTruthy();
      });

      it('returns true when above range', () => {
        expect(
          shouldVisibleRangeChange({
            elementsPerLine,
            leadingBufferLines,
            newFocusIndex: 8,
            trailingBufferLines,
            visibleRange,
          }),
        ).toBeTruthy();
      });
    });
  });
});
