export type Direction = 'horizontal' | 'vertical-grid' | 'vertical';

export type VisibleRange = number[];

export interface VisibleRangeBaseOpts {
  /**
   * The number of elements per line of the list. For non-grid lists, this value
   * should be 1.
   */
  elementsPerLine: number;
  /**
   * The number of lines rendered before the "visible area", allowing for
   * clipped edge rendering, prerendering, etc. Defaults to 0.
   */
  leadingBufferLines?: number;
  /**
   * The number of lines rendered after the "visible area", allowing for
   * clipped edge rendering, prerendering, etc. Defaults to 0.
   */
  trailingBufferLines?: number;
}
