import type { VisibleRange, VisibleRangeBaseOpts } from '../types';

export interface UpdateVisibleRangeOpts extends VisibleRangeBaseOpts {
  /**
   * The current VisibleRange array.
   */
  currentVisibleRange: VisibleRange;
  /**
   * The index of the new focused item.
   */
  newFocusIndex: number;
}

export function updateVisibleRange({
  currentVisibleRange,
  elementsPerLine,
  leadingBufferLines = 0,
  newFocusIndex,
  trailingBufferLines = 0,
}: UpdateVisibleRangeOpts): VisibleRange {
  const start = currentVisibleRange[leadingBufferLines * elementsPerLine];
  if (newFocusIndex < start) {
    return currentVisibleRange.map(
      (n) =>
        n -
        Math.ceil((start - newFocusIndex) / elementsPerLine) * elementsPerLine,
    );
  }

  const end =
    currentVisibleRange[
      currentVisibleRange.length - 1 - trailingBufferLines * elementsPerLine
    ];
  if (newFocusIndex > end) {
    return currentVisibleRange.map(
      (n) =>
        n +
        Math.ceil((newFocusIndex - end) / elementsPerLine) * elementsPerLine,
    );
  }

  return currentVisibleRange;
}
