import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { CoreText } from 'twitch-core-ui';
import { InfoText } from '.';

describe('InfoText', () => {
  const setup = createShallowWrapperFactory(InfoText, () => ({
    game: 'League of Legends',
    isLive: true,
    recordedAt: '2021-03-30T11:39:13Z',
    viewCount: 123456,
  }));

  it('renders all 5 CoreTexts when valid data is provided', () => {
    const { wrapper } = setup();
    expect(wrapper.find(CoreText)).toHaveLength(5);
  });

  it('does not render the middle text or divider when recordedAt is null', () => {
    const { wrapper } = setup({ recordedAt: null });
    expect(wrapper.find(CoreText)).toHaveLength(3);
  });
});
