import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { ScDisappearingContainer } from '.';

describe('ScDisappearingContainer', () => {
  const setup = createShallowWrapperFactory(ScDisappearingContainer, () => ({
    $visible: true,
  }));

  it('sets display none when not visible', () => {
    const { wrapper } = setup({ $visible: false });
    expect(wrapper).toHaveStyleRule('display', 'none');
  });

  it('does not set display none when visible', () => {
    const { wrapper } = setup({ $visible: true });
    expect(wrapper).toHaveStyleRule('display', 'flex');
  });
});
