import type { FC, ReactNode } from 'react';
import { Display, Layout } from 'twitch-core-ui';

export type PlaybackOverlayItemProps = {
  children: ReactNode;
};

// istanbul ignore next: trivial
/**
 * Common wrapper for bottom controls items to allow for
 * consistent spacing and alignment.
 */
export const PlaybackOverlayItem: FC<PlaybackOverlayItemProps> = ({
  children,
}) => {
  return (
    <Layout display={Display.Flex} margin={{ x: 2 }}>
      {children}
    </Layout>
  );
};

PlaybackOverlayItem.displayName = 'PlaybackOverlayItem';
