import type { TextCue } from 'pulsar';
import { useClosedCaptions } from 'pulsar';
import type { FC } from 'react';
import { useEffect, useState } from 'react';
import styled from 'styled-components';
import { CoreText, FontSize } from 'twitch-core-ui';

// istanbul ignore next: trivial
export const ScCoreText = styled(CoreText)`
  background-color: rgb(0, 0, 0);
  color: rgb(255, 255, 255);
  padding: 0 0.5rem;
`;

export const Captions: FC = () => {
  const { subscribe } = useClosedCaptions();
  const [caption, setCaption] = useState<TextCue | null>(null);

  useEffect(() => {
    return subscribe(setCaption);
  }, [subscribe]);

  if (!caption) {
    return null;
  }

  return <ScCoreText fontSize={FontSize.Size3}>{caption.text}</ScCoreText>;
};

Captions.displayName = 'Captions';
