import { useClosedCaptions } from 'pulsar';
import { act } from 'react-dom/test-utils';
import { createMountWrapperFactory } from 'tachyon-test-utils';
import { Captions } from '.';

jest.mock('pulsar', () => ({
  useClosedCaptions: jest.fn(),
}));

const mockUseClosedCaptions = useClosedCaptions as jest.Mock;

describe(Captions, () => {
  const setup = createMountWrapperFactory(Captions);

  beforeEach(() => {
    mockUseClosedCaptions.mockReturnValue({
      subscribe: jest.fn(),
    });
  });

  it('empty renders if it does not have a caption', () => {
    const { wrapper } = setup();
    expect(wrapper).toBeEmptyRender();
  });

  it('renders captions as they are received', () => {
    const mockSubscribe = jest.fn();
    mockUseClosedCaptions.mockReturnValue({ subscribe: mockSubscribe });

    const { wrapper } = setup();
    const handler = mockSubscribe.mock.calls[0][0];

    act(() => {
      handler({ text: 'caption 1' });
    });
    wrapper.update();
    expect(wrapper).toHaveText('caption 1');

    act(() => {
      handler({ text: 'caption 2' });
    });
    wrapper.update();
    expect(wrapper).toHaveText('caption 2');
  });
});
