import type { AdChannelInfo } from '.';
import { channelGetsAdRev } from '.';

describe('ad-text', () => {
  describe(channelGetsAdRev, () => {
    it('detects correctly', () => {
      expect(
        channelGetsAdRev({
          roles: { isAffiliate: false, isPartner: true },
        } as AdChannelInfo),
      ).toBeTruthy();
      expect(
        channelGetsAdRev({
          roles: { isAffiliate: true, isPartner: false },
        } as AdChannelInfo),
      ).toBeTruthy();

      expect(
        channelGetsAdRev({
          roles: { isAffiliate: false, isPartner: false },
        } as AdChannelInfo),
      ).toBeFalsy();
      expect(
        channelGetsAdRev({
          roles: { isAffiliate: null, isPartner: null },
        } as AdChannelInfo),
      ).toBeFalsy();
      expect(channelGetsAdRev({ roles: null } as AdChannelInfo)).toBeFalsy();
    });
  });
});
