import type { PlaybackAd } from 'pulsar';
import { createMountWrapperFactory } from 'tachyon-test-utils';
import { PlayingAdInfo } from '.';

describe(PlayingAdInfo, () => {
  const setup = createMountWrapperFactory(PlayingAdInfo, () => ({
    ad: {
      podCount: 1,
      podPosition: 1,
      remainingTimeSeconds: 30,
      vlm: false,
    } as PlaybackAd,
    channel: {
      displayName: 'therealderekt',
      login: 'therealderekt',
      roles: null,
    },
    live: true,
  }));

  it('empty renders if there is no ad playing', () => {
    const { wrapper } = setup({ ad: null });
    expect(wrapper).toBeEmptyRender();
  });

  it('renders if there is an ad playing', () => {
    const { wrapper } = setup();
    expect(wrapper).not.toBeEmptyRender();
  });

  it('does not render the ad count for a single ad', () => {
    const { wrapper } = setup({ ad: { podCount: 1, podPosition: 0 } });
    expect(wrapper).not.toIncludeText('1 of 1');
  });

  it('renders the ad count if there is more than one ad', () => {
    const { wrapper } = setup({ ad: { podCount: 3, podPosition: 0 } });
    expect(wrapper).toIncludeText('1 of 3');
  });
});
